<?php
// config.php - Database Configuration

// შეცვალეთ თქვენი cPanel-ის მონაცემებით
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');    // მაგ: username_hotel
define('DB_USER', 'your_database_user');    // მაგ: username_hotel
define('DB_PASS', 'your_password');

// Database connection function
function getConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $pdo;
    } catch(PDOException $e) {
        die(json_encode([
            'success' => false,
            'message' => 'Database connection failed: ' . $e->getMessage()
        ]));
    }
}
?>
