# 🏨 სასტუმროს დაჯავშნის სისტემა

სრული Backend + Frontend სისტემა სასტუმროს დაჯავშნების მართვისთვის MySQL მონაცემთა ბაზით.

## 📋 შემადგენლობა

- **Frontend (HTML/CSS/JS)**: 
  - `hotel-booking.html` - მომხმარებლის დაჯავშნის ფორმა
  - `admin-dashboard.html` - ადმინისტრატორის პანელი

- **Backend (Node.js + Express)**: 
  - `server.js` - API სერვერი
  - `database.sql` - მონაცემთა ბაზის სტრუქტურა

## 🚀 ინსტალაცია (ლოკალურად)

### 1. Node.js და npm ინსტალაცია
თუ არ გაქვთ, ჩამოტვირთეთ https://nodejs.org/

### 2. MySQL ინსტალაცია
- Windows: https://dev.mysql.com/downloads/installer/
- Mac: `brew install mysql`
- Linux: `sudo apt-get install mysql-server`

### 3. პროექტის დაყენება

```bash
# 1. შექმენით საქაღალდე
mkdir hotel-booking-system
cd hotel-booking-system

# 2. დააკოპირეთ ყველა ფაილი საქაღალდეში

# 3. დააინსტალირეთ Node.js დამოკიდებულებები
npm install

# 4. შექმენით მონაცემთა ბაზა
# გახსენით MySQL terminal და გაუშვით:
mysql -u root -p < database.sql

# ან ალტერნატიულად MySQL Workbench-ში:
# - გახსენით database.sql ფაილი
# - გაუშვით ყველა query
```

### 4. სერვერის კონფიგურაცია

გახსენით `server.js` და შეცვალეთ MySQL კრედენციალები:

```javascript
const db = mysql.createConnection({
    host: 'localhost',
    user: 'root',           // თქვენი MySQL username
    password: 'your_password',  // თქვენი MySQL password
    database: 'hotel_booking'
});
```

### 5. პროექტის სტრუქტურა

შექმენით შემდეგი სტრუქტურა:

```
hotel-booking-system/
│
├── server.js
├── package.json
├── database.sql
│
└── public/
    ├── hotel-booking.html
    └── admin-dashboard.html
```

Frontend ფაილები გადაიტანეთ `public/` საქაღალდეში.

### 6. სერვერის გაშვება

```bash
# Development mode (auto-restart)
npm run dev

# Production mode
npm start
```

სერვერი გაეშვება: http://localhost:3000

### 7. გახსენით ბრაუზერში

- დაჯავშნის ფორმა: http://localhost:3000/hotel-booking.html
- ადმინ პანელი: http://localhost:3000/admin-dashboard.html

## 🌐 ჰოსტინგზე ატვირთვა

### Variant 1: Shared Hosting (cPanel)

**არ გამოდგება** - საჭიროა Node.js და MySQL support

### Variant 2: VPS/Cloud (რეკომენდებული)

#### Option A: DigitalOcean / Linode / Vultr

```bash
# 1. შექმენით VPS droplet (Ubuntu 22.04)
# 2. დაუკავშირდით SSH-ით:
ssh root@your_server_ip

# 3. დააინსტალირეთ Node.js
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs

# 4. დააინსტალირეთ MySQL
sudo apt-get install mysql-server
sudo mysql_secure_installation

# 5. ატვირთეთ პროექტი
# გამოიყენეთ FileZilla ან scp:
scp -r /path/to/your/project root@your_server_ip:/var/www/hotel-booking

# 6. პროექტის გაშვება
cd /var/www/hotel-booking
npm install
npm start

# 7. PM2 დეიმონისთვის (რომ სერვერი ყოველთვის მუშაობდეს)
sudo npm install -g pm2
pm2 start server.js
pm2 startup
pm2 save
```

#### Option B: Heroku (უფასო/იაფი)

```bash
# 1. დააინსტალირეთ Heroku CLI
# https://devcenter.heroku.com/articles/heroku-cli

# 2. შექმენით Heroku app
heroku create your-hotel-booking

# 3. დაამატეთ MySQL addon
heroku addons:create jawsdb:kitefin

# 4. განახლეთ server.js რომ იყენებდეს Heroku MySQL:
# const db = mysql.createConnection(process.env.JAWSDB_URL);

# 5. Deploy
git init
git add .
git commit -m "Initial commit"
git push heroku main
```

#### Option C: Railway.app (რეკომენდებული - მარტივი)

1. გადადით https://railway.app/
2. დააკავშირეთ GitHub repository
3. დაამატეთ MySQL database service
4. Deploy ავტომატურად მოხდება

### Domain-ის მიბმა

```bash
# Nginx კონფიგურაცია:
sudo nano /etc/nginx/sites-available/hotel-booking

# დაამატეთ:
server {
    listen 80;
    server_name yourdomain.com;

    location / {
        proxy_pass http://localhost:3000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_cache_bypass $http_upgrade;
    }
}

# გააქტიურება:
sudo ln -s /etc/nginx/sites-available/hotel-booking /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl restart nginx
```

### SSL (HTTPS) დამატება

```bash
# Let's Encrypt (უფასო SSL)
sudo apt-get install certbot python3-certbot-nginx
sudo certbot --nginx -d yourdomain.com
```

## 🔧 Frontend-ში API URL-ის შეცვლა

Production-ისთვის შეცვალეთ `hotel-booking.html` და `admin-dashboard.html` ფაილებში:

```javascript
// ლოკალური:
fetch('http://localhost:3000/api/bookings', ...)

// Production:
fetch('https://yourdomain.com/api/bookings', ...)

// ან გამოიყენეთ relative URL:
fetch('/api/bookings', ...)
```

## 📊 ფუნქციები

### მომხმარებლის მხარე:
- ✅ ინტერაქტიული დაჯავშნის ფორმა
- ✅ ავტომატური ფასის გამოთვლა
- ✅ რეალურ დროში ვალიდაცია
- ✅ ინვოისის გენერაცია და ჩამოტვირთვა
- ✅ მონაცემთა ბაზაში შენახვა

### ადმინისტრატორის მხარე:
- ✅ ყველა დაჯავშნის ნახვა
- ✅ სტატისტიკა და ანალიტიკა
- ✅ ძებნა და ფილტრაცია
- ✅ სტატუსის შეცვლა
- ✅ დაჯავშნების წაშლა

## 🔐 უსაფრთხოება

Production-ისთვის აუცილებლად:

1. **გამოიყენეთ Environment Variables**:
```bash
# .env ფაილი:
DB_HOST=localhost
DB_USER=root
DB_PASSWORD=your_secure_password
DB_NAME=hotel_booking
PORT=3000

# server.js-ში:
require('dotenv').config();
const db = mysql.createConnection({
    host: process.env.DB_HOST,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME
});
```

2. **დაამატეთ ავთენტიფიკაცია admin panel-ში**
3. **გამოიყენეთ HTTPS**
4. **დაამატეთ rate limiting**
5. **Sanitize user inputs**

## 📱 კონტაქტი და მხარდაჭერა

თუ დაგჭირდათ დახმარება ჰოსტინგზე ატვირთვაში ან კონფიგურაციაში, მოგვწერეთ!

## 📝 ლიცენზია

MIT License - თავისუფლად გამოიყენეთ და შეცვალეთ თქვენი საჭიროებისამებრ.
